<?php $__env->startSection('content'); ?>

<div class="d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
    <h6 class="fw-semibold mb-0">Document Search</h6>
    <ul class="d-flex align-items-center gap-2">
        <li class="fw-medium">
            <a href="<?php echo e(route('dashboard')); ?>" class="d-flex align-items-center gap-1 hover-text-primary">
                <iconify-icon icon="solar:home-smile-angle-outline" class="icon text-lg"></iconify-icon>
                My DTS Section
            </a>
        </li>
       
        <li class="fw-medium">
          <?php if(isset($myAllSections) && count($myAllSections) > 0): ?>
            <div class="btn-group dropstart">
                <button class="btn btn-success-600 bg-success-100 border-success-100 text-success-600 hover-text-success not-active px-18 py-11 dropdown-toggle toggle-icon icon-left" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                     <?php if(isset($mySection) && $mySection != NULL): ?>
                    <?php echo e($mySection); ?>

                    <?php elseif(isset($myAllSections) && count($myAllSections) > 0): ?>                        
                        Select Section
                    <?php endif; ?>
                </button>
              
                <ul class="dropdown-menu">                   
                    <?php $__currentLoopData = $myAllSections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $section): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li>
                            <a class="dropdown-item px-16 py-8 rounded text-secondary-light bg-hover-neutral-200 text-hover-neutral-900"
                               href="javascript:void(0)"
                               onclick="submitSectionForm('<?php echo e($section->id); ?>')">
                               <?php echo e($section->name); ?>

                            </a>
                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>                  
                    
                </ul>
                
            </div>
            
            <!-- Form to submit the selected section_id -->
            <form id="section-form" method="POST" action="<?php echo e(route('user.updateStation')); ?>" style="display: none;">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="station_id" id="station-id">
            </form>
            <?php endif; ?>
            
        </li>
    </ul>
</div>

<div class="card basic-data-table">
  
  
    <div class="card-header">
        <h5 class="card-title mb-0">Search Results</h5>
    </div>
    <div class="card-body">
        <?php if($errors->any()): ?>
            <div class="m-3 alert alert-danger bg-danger-100 text-danger-600 border-danger-100 px-24 py-11 mb-0 fw-semibold text-lg radius-8 d-flex align-items-center justify-content-between" role="alert">
            <div class="d-flex align-items-center gap-2">
            <iconify-icon icon="mdi:alert-circle-outline" class="icon text-xl"></iconify-icon>
            <ul>
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
            </div>
            <button class="remove-button text-danger-600 text-xxl line-height-1"> <iconify-icon icon="iconamoon:sign-times-light" class="icon"></iconify-icon></button>
            </div>
           
            <div> &nbsp;</div>
         <?php endif; ?>


        
            <table  id="searchdataTable" class="table table-striped">
            <thead>
                <tr>
                    
                    <th style="text-align: left;">Tracking</th>
                    <th>Particulars</th>
                    <th>From</th>                  
                  
                    <th></th>
                   
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $documents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $doc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        
                        <td><?php echo e($doc->tracking_code); ?></td>
                        <td><?php echo e($doc->description); ?></td>
                        <td> 
                            <?php if($doc->fromUser): ?>
                            <?php echo e($doc->fromUser->name); ?>                        
                            <?php else: ?>                           
                           <?php echo e($doc->guest_origin_name); ?>

                           <br><small>(Guest Acct)</small> 
                            <?php endif; ?>
                        </td>
                        <td>
                            <a href="<?php echo e(route('dts.document-view', $doc->id)); ?>" class="btn rounded-pill btn-outline-lilac-600 radius-8 px-20 py-11" style="font-size:0.8rem;">View</a>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
        <hr class="my-3">
        <div class="d-flex justify-content-center">
            <?php echo e($documents->links()); ?>

        </div>
    </div>
</div>



<?php $__env->stopSection(); ?>


<?php $__env->startSection('styles'); ?>
<style>
    .description-column {
        width: 20%;
    }

    /* Ensure the table fits 100% width of its container */
    .table-responsive {
        width: 100%;
        overflow-x: auto;
    }

    .table {
        width: 100%;
        margin-bottom: 1rem;
        color: #212529;
    }
</style>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>

<script>
    $(document).ready(function() {
        $('#searchdataTable').DataTable({
            responsive: true,
            autoWidth: false, // Prevent auto-calculation of width by DataTables
            columnDefs: [
             //   { targets: 0, visible: false }, // Hide the first column
                { width: '13ch', targets: 0 },
                { width: '45%', targets: 1 } // Set the width of the description column
            ],
            "pageLength": 25,
            order: [[0, 'desc']] 
        });
    });

   
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dts-admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\marny\Downloads\dts-ver-3.3-main (1)\dts-ver-3.3-main\resources\views/dts/searched-list.blade.php ENDPATH**/ ?>