<?php $__env->startSection('content'); ?>

<div class="d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
    <h6 id="pageheading" class="fw-semibold text-success mb-0 d-none d-md-block">    
      DTS - <?php echo e($mySection); ?> 
    </h6>
    <ul class="d-flex align-items-center gap-2">
      <li class="fw-medium">
        <a href="<?php echo e(route('dashboard')); ?>" class="d-flex align-items-center gap-1 hover-text-primary">
          <iconify-icon icon="solar:home-smile-angle-outline" class="icon text-lg"></iconify-icon>
         My Station Dashboard
        </a>
      </li>
      <li>-</li>
      <li class="fw-medium">
          
        <div class="btn-group dropstart">
            <button class="btn btn-success-600 bg-success-100 border-success-100 text-success-600 hover-text-success not-active px-18 py-11 dropdown-toggle toggle-icon icon-left" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                 <?php if(isset($mySection) && $mySection != NULL): ?>
                <?php echo e($mySection); ?>

                <?php elseif(isset($myAllSections) && count($myAllSections) > 0): ?>                        
                    Select Section
                <?php endif; ?>
            </button>
            <ul class="dropdown-menu">
                <?php if(isset($myAllSections)): ?>
                <?php $__currentLoopData = $myAllSections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $section): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li>
                        <a class="dropdown-item px-16 py-8 rounded text-secondary-light bg-hover-neutral-200 text-hover-neutral-900"
                           href="javascript:void(0)"
                           onclick="submitSectionForm('<?php echo e($section->id); ?>')">
                           <?php echo e($section->name); ?>

                        </a>
                    </li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                
            </ul>
        </div>
        
        <!-- Form to submit the selected section_id -->
        <form id="section-form" method="POST" action="<?php echo e(route('user.updateStation')); ?>" style="display: none;">
            <?php echo csrf_field(); ?>
            <input type="hidden" name="station_id" id="station-id">
        </form>
        <?php endif; ?>
    </li>
    </ul>
  </div>

  
      
      <div class="card ">
        <div class="card-header">
          <h5>My Station Statistics</h5>
    </div>
        
        <div class="card-body">

          <?php if($errors->any()): ?>
              <div class="m-3 alert alert-danger bg-danger-100 text-danger-600 border-danger-100 px-24 py-11 mb-0 fw-semibold text-lg radius-8 d-flex align-items-center justify-content-between" role="alert">
              <div class="d-flex align-items-center gap-2">
              <iconify-icon icon="mdi:alert-circle-outline" class="icon text-xl"></iconify-icon>
              <ul>
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </ul>
              </div>
              <button class="remove-button text-danger-600 text-xxl line-height-1"> <iconify-icon icon="iconamoon:sign-times-light" class="icon"></iconify-icon></button>
              </div>
            <?php endif; ?>

         
               
            <?php if(Auth::user()->section_id == NULL): ?>
            <div class="alert alert-danger" role="alert">
             <h4 class="alert-heading">No Section Assigned!</h4>
             <p>You have not been assigned to any section. Please contact the system administrator.</p>
            </div>
            <?php else: ?>

<!--Start of the first row -->
<div class="row">
  <div class="col-sm-6">
    <div class="card">
      <div class="card-header">
            <h6>Data Query Form</h6>
      </div>
         <div class="card-body">
  
          <form action="<?php echo e(route('dts.my-station.query-dates')); ?>" method="post">
            <?php echo csrf_field(); ?>
              <div class="mb-3">
                <label for="begin_date" class="form-label">Begin Date</label>
                <input type="date" class="form-control" id="begin_date" name="begin_date" value="<?php echo e(session('beginDate')); ?>">
              </div>
              <div class="mb-3">
                <label for="end_date" class="form-label">End Date</label>
                <input type="date" class="form-control" id="end_date" name="end_date" value="<?php echo e(session('endDate')); ?>">
              </div>

              <button type="submit" class="btn btn-primary">Submit</button>
                <a href="<?php echo e(route('dts.my-station.clear-dates')); ?>" class="btn btn-secondary float-end">Clear</a>
              
          </form>
          
         </div>
  
    </div>
  
  </div>
  <div class="col-sm-6">
    <div class="card">
      <div class="card-header">
        <div class="fw-semibold text-success mb-0">
        <?php if(session('beginDate') && session('endDate')): ?>
        <div>For DB Query Dates: <?php echo e(\Carbon\Carbon::parse(session('beginDate'))->format('F j, Y')); ?> to <?php echo e(\Carbon\Carbon::parse(session('endDate'))->format('F j, Y')); ?></div>
        <?php endif; ?>
        </div>
      </div>
      <div class="card-body">
        <table class="table table-bordered table-striped">
          <?php if(session('beginDate') && session('endDate')): ?>
          <tr>
            <td>Received Documents <small>(Accepted from dates specified.)</small></td>
            <td><?php echo e(isset($receivedCount) ? $receivedCount : 0); ?></td>
            <td>
              <a href="<?php echo e(route('dts.my-section-received')); ?>" class="btn btn-primary-300 btn-sm">View</a>
            </td>
          </tr>
          <?php endif; ?>
          <?php if(session('beginDate') && session('endDate')): ?>
          <tr>
            <td>Forwarded Documents <small>(Forwarded from dates specified.)</small></td>
            <td><?php echo e(isset($forwardedCount ) ? $forwardedCount  : 0); ?></td>
            <td>
              <a href="<?php echo e(route('dts.my-section-forwarded')); ?>" class="btn btn-primary-300 btn-sm">View</a>
            </td>
          </tr>
          <?php endif; ?>
        <?php if(session('beginDate') && session('endDate')): ?>
        <tr>
          <td>Documents Kept</td>
          <td><?php echo e(isset($documentsKeptCount) ? $documentsKeptCount : 0); ?></td>
          <td>
            <a href="<?php echo e(route('dts.my-section-kept')); ?>" class="btn btn-success-300 btn-sm">View</a>
          </td>
        </tr>
        <?php endif; ?>
        
        <?php if(session('beginDate') && session('endDate')): ?>
        <tr>
          <td>Remaining Documents Pending/Deferred (No action has been initiated yet)
            <br>
            <small>Documents received are from the dates specified.</small>
          </td>
          <td><?php echo e(isset($pendingCount) ? $pendingCount : 0); ?></td>
          <td>
            <a href="<?php echo e(route('dts.mysection-pending-documents')); ?>" class="btn btn-danger-300 btn-sm">View</a>
          </td>
        </tr>
        <?php endif; ?>
          

        </table>

         



      </div>
    </div>
  
  </div>
  
  </div>
  
  
  <!--End of the first row -->
<!--Start of the second row -->
<?php if(session('beginDate') && session('endDate')): ?>
<div class="row">
  <div class="col-sm-6">
    <div class="card">
      <div class="card-header">
        <div class="text-lg text-lime-600">Documents Received by Doc Types</div>
      </div>
      <div class="card-body">
        <table class="table table-bordered table-striped">
          <?php if(isset($receivedDocsByType) && count($receivedDocsByType) > 0): ?>
          <tr>
            <th>Description</th>
            <th> <div class="text-center">Total</div></th>
          </tr>
          <?php $__currentLoopData = $receivedDocsByType; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $doc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <tr>
            <td><?php echo e($doc->description); ?></td>
            <td><div class="text-center"><?php echo e($doc->total); ?></div></td>
          </tr>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          <?php endif; ?>
        </table>

      </div>
    </div>
  </div>
  <div class="col-sm-6">
    <div class="card">
      <div class="card-header">
        <div class="text-lg text-lime-600">Documents Forwarded by Doc Types</div>
      </div>
      <div class="card-body">
        <table class="table table-bordered table-striped">
          <?php if(isset($forwardedDocsByType) && count($forwardedDocsByType) > 0): ?>
          <tr>
            <th>Description</th>
            <th> <div class="text-center">Total</div></th>
          </tr>
          <?php $__currentLoopData = $forwardedDocsByType; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $doc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <tr>
            <td><?php echo e($doc->description); ?></td>
            <td><div class="text-center"><?php echo e($doc->total); ?></div></td>
          </tr>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          <?php endif; ?>
        </table>

      </div>
    </div>


  </div>
 

</div>
<?php endif; ?>
<!--End of the second row -->




  <div class="row mt-50">

    <div class="col-sm-6">
      <div class="card">
        <div class="card-header">
          <div class="fw-semibold text-success mb-0">As of Today's Count Documents Received</div>
        </div>
        <div class="card-body">
          
          <table class="table table-bordered table-striped">
          <tr>
            <th>Last Year Count (<?php echo e(date('Y', strtotime('-1 year'))); ?>)</th>
            <td class="text-center"><?php echo e(isset($myStationStats) ? $myStationStats->last_year_count : 0); ?></td>
          </tr>
          <tr>
            <th>This Year Count (<?php echo e(date('Y')); ?>)</th>
            <td class="text-center"><?php echo e(isset($myStationStats) ? $myStationStats->ytd_count : 0); ?></td>
          </tr>
          <tr>
            <th>Today's Count (<?php echo e(date('F j, Y')); ?>)</th>
            <td class="text-center"><?php echo e(isset($myStationStats) ? $myStationStats->today_count : 0); ?></td>
          </tr>
          <tr>
            <th>Yesterday Count (<?php echo e(date('F j, Y', strtotime('-1 day'))); ?>)</th>
            <td class="text-center"><?php echo e(isset($myStationStats) ? $myStationStats->yesterday_count : 0); ?></td>
          </tr>
          <tr>
            <th>This Week Count (<?php echo e(date('F j, Y', strtotime('monday this week'))); ?> - <?php echo e(date('F j, Y', strtotime('sunday this week'))); ?>)</th>
            <td class="text-center"><?php echo e(isset($myStationStats) ? $myStationStats->week_count : 0); ?></td>
          </tr>
          <tr>
            <th>Last Week Count (<?php echo e(date('F j, Y', strtotime('monday last week'))); ?> - <?php echo e(date('F j, Y', strtotime('sunday last week'))); ?>)</th>
            <td class="text-center"><?php echo e(isset($myStationStats) ? $myStationStats->last_week_count : 0); ?></td>
          </tr>
          <tr>
            <th>This Month Count (<?php echo e(date('F')); ?>)</th>
            <td class="text-center"><?php echo e(isset($myStationStats) ? $myStationStats->month_count : 0); ?></td>
          </tr>
          <tr>
            <th>Last Month Count (<?php echo e(date('F', strtotime('first day of last month'))); ?>)</th>
            <td class="text-center"><?php echo e(isset($myStationStats) ? $myStationStats->last_month_count : 0); ?></td>
          </tr>             
            
          </table>
          
          
        </div>
      </div>
     
    </div>
    <div class="col-sm-6">
      <div class="card">    
        <div class="card-header">
          <div class="fw-semibold text-primary mb-0"> As of Today's Count Documents Forwarded</div>
          </div>    
        <div class="card-body">
          
            <table class="table table-bordered table-striped">
            <tr>
              <th>Last Year Count (<?php echo e(date('Y', strtotime('-1 year'))); ?>)</th>
              <td class="text-center"><?php echo e(isset($myStationForwardedStats) ? $myStationForwardedStats->last_year_count : 0); ?></td>
            </tr>
            <tr>
              <th>This Year Count (<?php echo e(date('Y')); ?>)</th>
              <td class="text-center"><?php echo e(isset($myStationForwardedStats) ? $myStationForwardedStats->ytd_count : 0); ?></td>
            </tr>
            <tr>
              <th>Today's Count (<?php echo e(date('F j, Y')); ?>)</th>
              <td class="text-center"><?php echo e(isset($myStationForwardedStats) ? $myStationForwardedStats->today_count : 0); ?></td>
            </tr>
            <tr>
              <th>Yesterday Count (<?php echo e(date('F j, Y', strtotime('-1 day'))); ?>)</th>
              <td class="text-center"><?php echo e(isset($myStationForwardedStats) ? $myStationForwardedStats->yesterday_count : 0); ?></td>
            </tr>
            <tr>
              <th>This Week Count (<?php echo e(date('F j, Y', strtotime('monday this week'))); ?> - <?php echo e(date('F j, Y', strtotime('sunday this week'))); ?>)</th>
              <td class="text-center"><?php echo e(isset($myStationForwardedStats) ? $myStationForwardedStats->week_count : 0); ?></td>
            </tr>
            <tr>
              <th>Last Week Count (<?php echo e(date('F j, Y', strtotime('monday last week'))); ?> - <?php echo e(date('F j, Y', strtotime('sunday last week'))); ?>)</th>
              <td class="text-center"><?php echo e(isset($myStationForwardedStats) ? $myStationForwardedStats->last_week_count : 0); ?></td>
            </tr>
            <tr>
              <th>This Month Count (<?php echo e(date('F')); ?>)</th>
              <td class="text-center"><?php echo e(isset($myStationForwardedStats) ? $myStationForwardedStats->month_count : 0); ?></td>
            </tr>
            <tr>
              <th>Last Month Count (<?php echo e(date('F', strtotime('first day of last month'))); ?>)</th>
              <td class="text-center"><?php echo e(isset($myStationForwardedStats) ? $myStationForwardedStats->last_month_count : 0); ?></td>
            </tr>
          </table>            
        </div>
        </div>
    </div>
  </div><!--end row -->


   </div><!--end row -->
<!--Start of the second row -->



<!--End of the second row -->
  <?php endif; ?>


      </div>


<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>


<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.dts-admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\marny\Downloads\dts-ver-3.3-main (1)\dts-ver-3.3-main\resources\views/dts/mysection/my-station.blade.php ENDPATH**/ ?>