<?php $__env->startSection('content'); ?>

<div class="d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
  <h6 class="fw-semibold text-success mb-0 d-none d-md-block">
           <?php echo e($systemSetting->custom_system_name); ?>

    </h6>
    <ul class="d-flex align-items-center gap-2">
      <li class="fw-medium">
        <a href="<?php echo e(route('dashboard')); ?>" class="d-flex align-items-center gap-1 hover-text-primary">
          <iconify-icon icon="solar:home-smile-angle-outline" class="icon text-lg"></iconify-icon>
         My Station Dashboard
        </a>
      </li>
      <li>-</li>
      <li class="fw-medium">
          
        <div class="btn-group dropstart">
            <button class="btn btn-success-600 bg-success-100 border-success-100 text-success-600 hover-text-success not-active px-18 py-11 dropdown-toggle toggle-icon icon-left" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                 <?php if(isset($mySection) && $mySection != NULL): ?>
                <?php echo e($mySection); ?>

                <?php elseif(isset($myAllSections) && count($myAllSections) > 0): ?>                        
                    Select Section
                <?php endif; ?>
            </button>
            <ul class="dropdown-menu">
                <?php if(isset($myAllSections)): ?>
                <?php $__currentLoopData = $myAllSections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $section): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li>
                        <a class="dropdown-item px-16 py-8 rounded text-secondary-light bg-hover-neutral-200 text-hover-neutral-900"
                           href="javascript:void(0)"
                           onclick="submitSectionForm('<?php echo e($section->id); ?>')">
                           <?php echo e($section->name); ?>

                        </a>
                    </li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                
            </ul>
        </div>
        
        <!-- Form to submit the selected section_id -->
        <form id="section-form" method="POST" action="<?php echo e(route('user.updateStation')); ?>" style="display: none;">
            <?php echo csrf_field(); ?>
            <input type="hidden" name="station_id" id="station-id">
        </form>
        <?php endif; ?>
    </li>
    </ul>
  </div>

  
      
      <div class="card basic-data-table">
        
        <div class="card-body">
         
          <?php if($errors->any()): ?>
              <div class="m-3 alert alert-danger bg-danger-100 text-danger-600 border-danger-100 px-24 py-11 mb-0 fw-semibold text-lg radius-8 d-flex align-items-center justify-content-between" role="alert">
              <div class="d-flex align-items-center gap-2">
              <iconify-icon icon="mdi:alert-circle-outline" class="icon text-xl"></iconify-icon>
              <ul>
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </ul>
              </div>
              <button class="remove-button text-danger-600 text-xxl line-height-1"> <iconify-icon icon="iconamoon:sign-times-light" class="icon"></iconify-icon></button>
              </div>
            <?php endif; ?>
     <?php if($mySection != NULL): ?>
         <div class="row">
          <div class="col-sm-6">         
            
      <!--Card New -->
                <div class="card h-100 radius-12">
                  <div class="card-body p-24">
                    <div class="w-64-px h-64-px d-inline-flex align-items-center justify-content-center bg-gradient-purple text-lilac-600 mb-16 radius-12">
                      <iconify-icon icon="mdi:qrcode-scan" class="h5 mb-0"></iconify-icon>
                    </div>
                    <h6 class="fw-semibold mb-12">Quick Document Receiving</h6>
                    <p>
                      Streamline document acceptance with QuickScan. Just scan a QR code to accept documents quickly and securely, reducing paperwork and processing time.
                    </p>
                    <label class="form-label">QR Code Scan</label>
                    <form action="<?php echo e(route('dts.quick-receipt')); ?>" method="post" id="qrcode-form">
                      <?php echo csrf_field(); ?>
                      <div class="input-group">
                        <span class="input-group-text bg-base">
                          <iconify-icon icon="ic:twotone-qrcode"></iconify-icon>
                        </span>
                        <input type="text" class="form-control flex-grow-1" name="doc_track" autofocus>
                      </div>
                    </form>
                  </div>
                </div>

               
      <!--//End Card New -->    
          </div>
          <div class="col-sm-6">
            <div class="card h-100 radius-12 text-end">
              <div class="card-body p-24">
                  <div class="w-64-px h-64-px d-inline-flex align-items-center justify-content-center bg-gradient-success text-success-600 mb-16 radius-12">
                      <iconify-icon icon="hugeicons:binary-code" class="h5 mb-0"></iconify-icon> 
                  </div>
                  <h6 class="mb-8">Alternate Doc Receiving</h6>
                  <p class="card-text mb-8 text-secondary-light pb-8">
                    While you do not have a QR code scanner, you may go to the <a href="<?php echo e(route('dts.incoming-docs.index')); ?>">  <button class="px-3" style="background-color: rgb(234, 247, 190); border-radius: 10px;"> Incoming-route Page </button> </a> search for the document then accept or encode the tracking number below, click submit and accept the document.
                  </p>
                  
                    <div class="text-end pt-8">
                    <form action="<?php echo e(route('dts.qrcode-search')); ?>" method="post"  class="row g-2 justify-content-end">
                     <?php echo csrf_field(); ?>
                    <div class="col-auto">
                      <label for="inputPassword2" class="visually-hidden">Tracking Number</label>
                      <input type="text" class="form-control" id="inputPassword2" name="doc_track" placeholder="Tracking Number">
                    </div>
                    <div class="col-auto">
                      <button type="submit" class="btn btn-primary mb-3">Submit</button>
                    </div>
                    </form>                  
                  </div>
                <div>
                 
                </div>
                
              </div>
          </div>

          </div>
         </div> <!--//row-->
  <div style="padding-top: 25px;"> </div>
  <div class="row">
    <div class="col-sm-6">
      <div class="card">
        <div class="card-body">
          <h6 class="fw-semibold text-danger mb-6">QR scanning using webcam or mobile cam</h6>
        <p>
        You may also scan a QR code using your webcam. Just click the link button below to start scanning.

        </p> 
        <p>
          <a href="<?php echo e(route('dts.webcam-qr-scan')); ?>" class="btn btn-success">Webcam Scanning Page</a>
          
        </p>
          
          
        </div>
      </div>
     
    </div>
    <div class="col-sm-6">
      <div class="card">  
        <div class="card-header"><?php echo e($mySection); ?> Today's Received Counts</div>      
        <div class="card-body">
            <h1 class="fw-semibold text-danger mb-0 text-center"> <?php echo e($sectionReceivedCount->today_count ?? ""); ?> </h1>
      
            <?php if(session('success')): ?>          
            
            <div class="alert alert-success bg-success-100 text-success-600 border-success-100 px-24 py-11 mb-0 fw-semibold text-lg radius-8 d-flex align-items-center justify-content-between" role="alert">
              <div class="d-flex align-items-center gap-2">
                  <iconify-icon icon="akar-icons:double-check" class="icon text-xl"></iconify-icon>
                  <?php echo e(session('success')); ?>

              </div>
              <button class="remove-button text-success-600 text-xxl line-height-1"> <iconify-icon icon="iconamoon:sign-times-light" class="icon"></iconify-icon></button>
          </div>
        
        <?php endif; ?>
      
        </div><!--card body -->
        

      </div>

    </div>
  </div>




  
        </div>



      <?php else: ?>
              

              <div class="alert alert-warning bg-warning-100 text-warning-600 border-warning-100 px-24 py-11 mb-0 fw-semibold text-lg radius-8 d-flex align-items-center justify-content-between" role="alert">
                <div class="d-flex align-items-center gap-2">
                    <iconify-icon icon="mdi:alert-circle-outline" class="icon text-xl"></iconify-icon>
                   Please ask the system administrator to assign you to a section.
                </div>
                <button class="remove-button text-warning-600 text-xxl line-height-1"> <iconify-icon icon="iconamoon:sign-times-light" class="icon"></iconify-icon></button>
              </div>
      
      <?php endif; ?>


      </div>





<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>

<script>
  document.getElementById('doc_track').addEventListener('change', function() {
      document.getElementById('qrcode-form').submit();
  });
</script>
  
  <?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.dts-admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\marny\Downloads\dts-ver-3.3-main (1)\dts-ver-3.3-main\resources\views/dts/dts-dashboard.blade.php ENDPATH**/ ?>