<?php $__env->startSection('content'); ?>
<div class="d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
    <h6 class="fw-semibold mb-0">Document Tracking System</h6>
    <ul class="d-flex align-items-center gap-2">
        <li class="fw-medium">
            <a href="#" class="d-flex align-items-center gap-1 hover-text-primary">
                <iconify-icon icon="solar:home-smile-angle-outline" class="icon text-lg"></iconify-icon>
                DTS-Dashboard
            </a>
        </li>
        <li>-</li>
        <li class="fw-medium">
            <?php if(isset($myAllSections) && count($myAllSections) > 0): ?>
            <div class="btn-group dropstart">
                <button class="btn btn-success-600 bg-success-100 border-success-100 text-success-600 hover-text-success not-active px-18 py-11 dropdown-toggle toggle-icon icon-left" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                     <?php if(isset($mySection) && $mySection != NULL): ?>
                    <?php echo e($mySection); ?>

                    <?php elseif(isset($myAllSections) && count($myAllSections) > 0): ?>                        
                        Select Section
                    <?php endif; ?>
                </button>
              
                <ul class="dropdown-menu">                   
                    <?php $__currentLoopData = $myAllSections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $section): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li>
                            <a class="dropdown-item px-16 py-8 rounded text-secondary-light bg-hover-neutral-200 text-hover-neutral-900"
                               href="javascript:void(0)"
                               onclick="submitSectionForm('<?php echo e($section->id); ?>')">
                               <?php echo e($section->name); ?>

                            </a>
                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>                  
                    
                </ul>
                
            </div>
            
            <!-- Form to submit the selected section_id -->
            <form id="section-form" method="POST" action="<?php echo e(route('user.updateStation')); ?>" style="display: none;">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="station_id" id="station-id">
            </form>
            <?php endif; ?>
        </li>
    </ul>
</div>
 <!-- Validation display -->
 <?php if($errors->any()): ?>
 <div class="mt-3 alert alert-danger bg-danger-100 text-danger-600 border-danger-100 px-24 py-11 mb-0 fw-semibold text-lg radius-8 d-flex align-items-center justify-content-between" role="alert">
 <div class="d-flex align-items-center gap-2">
 <iconify-icon icon="mdi:alert-circle-outline" class="icon text-xl"></iconify-icon>
 <ul>
     <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
         <li><?php echo e($error); ?></li>
     <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
 </ul>
 </div>
 <button class="remove-button text-danger-600 text-xxl line-height-1"> <iconify-icon icon="iconamoon:sign-times-light" class="icon"></iconify-icon></button>
 </div>
<?php endif; ?>
<!--ednValidation display -->

<div class="row">
    <div class="col-sm-7">
        <div class="card basic-data-table">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <?php if(isset($tableTitle)): ?>
                        <?php echo e($tableTitle); ?>

                    <?php else: ?>
                        Submit New Document
                    <?php endif; ?>
                </h5>
            </div>
            <div class="card-body">
                <?php if($mySection != NULL): ?>
                <form action="<?php echo e(route('dts.documents.store')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="row mb-24 gy-3 align-items-center">
                        <label for="from" class="form-label mb-0 col-sm-3">From</label>
                        <div class="col-sm-9">
                            <input type="text" id="from" class="form-control form-control-sm" value="<?php echo e(Auth::user()->name); ?> | <?php echo e($mySection); ?>" readonly>
                            <input type="hidden" name="fromuser_id" value="<?php echo e(Auth::user()->id); ?>">
                            <input type="hidden" name="from_section_id" value="<?php echo e(Auth::user()->station_id); ?>">
                        </div>
                    </div>
                    <div class="row mb-24 gy-3 align-items-center">
                        <label for="dts_doc_type_id" class="form-label mb-0 col-sm-3">Document Type</label>
                        <div class="col-sm-9">
                            <select name="dts_doc_type_id" id="dts_doc_type_id" class="form-control form-control-sm" required>
                                <option value="">Select Document Type</option>
                                <?php $__currentLoopData = $docTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($type->id); ?>"><?php echo e($type->description); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <input type="hidden" name="tracking_issuedby_id" value="<?php echo e(Auth::user()->id); ?>">
                        </div>
                    </div>
                  
                    <div class="row mb-24 gy-3 align-items-center">
                        <label for="description" class="form-label mb-0 col-sm-3">Description</label>
                        <div class="col-sm-9">
                              <textarea id="description" class="form-control text-box-small" name="description" rows="3" required></textarea>
                        </div>
                    </div>
                    <div class="row mb-24 gy-3 align-items-center">
                        <label for="actions_needed" class="form-label mb-0 col-sm-3">Actions Needed (Route Purpose)</label>
                        <div class="col-sm-9">
                            <input type="text" id="actions_needed" class="form-control form-control-sm" name="actions_needed">
                            <input type="hidden" name="from_section_id" value="<?php echo e(Auth::user()->section_id); ?>">
                        </div>
                    </div>
                    <div class="row mb-24 gy-3 align-items-center">
                        <label for="to_section_id" class="form-label mb-0 col-sm-3">Route to Section</label>
                        <div class="col-sm-9">
                            <select name="to_section_id" id="to_section_id" class="form-control form-control-sm" required>
                                <option value="" style="visibility: hidden; display:none;">Select Section</option>
                                <?php $__currentLoopData = $sections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $section): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($section->id); ?>"><?php echo e($section->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>
                    <div class="row mb-24 gy-3 align-items-center">
                        <label for="to_user_id" class="form-label mb-0 col-sm-3">Employee</label>
                        <div class="col-sm-9">
                            <select name="to_user_id" id="to_user_id" class="form-control form-control-sm" required>
                                <option value="" style="visibility: hidden; display:none;">Select Staff</option>
                                <!-- Options will be dynamically populated here -->
                            </select>
                             <div class="alert alert-danger mt-2 d-none" id="user-fetch-error">
                                An error occurred while fetching users. Please try again.
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-6"></div>
                        <div class="col-sm-6 d-flex justify-content-end">
                            <button type="submit" class="btn btn-primary-600">Submit</button>
                        </div>
                    </div>
                </form>
                <?php else: ?>
                <div> Please Ask the system admin to assign you to a DTS Section or Station</div>
                <?php endif; ?>
            </div>
        </div>
    </div>
    <div class="col-sm-5">
        <div class="card">
            <div class="card-header">
               <h6>Form Instructions</h6> 
            </div>
            <div class="card-body">
                <p style="font-size:1.1rem; font-weight: bold;">Description Field</p>
                <p>
                    Please provide a detailed description of the document content. For example, if the document type is Authority to Travel, include the following in the description: <span style="font-weight: bold;">your destination, the purpose of travel, and the travel dates. </span>
                </p>  <p>
                    If it is a communication letter, please give a short description of its purpose and to where it is addressed.
                </p>
                <p>
                    If it is for procurement, liquidation, or reimbursement, please include the amount, attachments, and the document dates.
                </p>
                <p style="font-size:1.1rem; font-weight: bold;">Actions Needed Field</p>
                <p>
                    Please specify the purpose of routing this document. For example, indicate if the document is being sent for approval, review, signature, or for information. </p>
                </p>

                

            </div>
        </div>
       
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    $(document).ready(function() {
        var baseUrl = "<?php echo e(url('/')); ?>"; // Get the base URL

        $('#to_section_id').change(function() {
            var sectionId = $(this).val();
            var userDropdown = $('#to_user_id');
            var errorAlert = $('#user-fetch-error');
            
            userDropdown.empty().append('<option value="">Select Staff</option>'); // Clear current options

            if (sectionId) {
                $.ajax({
                    url: baseUrl + '/dts/get-users-by-section/' + sectionId,
                    type: 'GET',
                    dataType: 'json',
                    beforeSend: function() {
                        userDropdown.prop('disabled', true);
                        errorAlert.addClass('d-none');
                    },
                    success: function(data) {
                        $.each(data, function(index, user) {
                            userDropdown.append('<option value="' + user.id + '">' + user.name + '</option>');
                        });
                        userDropdown.prop('disabled', false);
                    },
                    error: function(error) {
                        console.error('Error fetching users:', error);
                        errorAlert.removeClass('d-none');
                        userDropdown.prop('disabled', false);
                    }
                });
            }
        });
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dts-admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\marny\Downloads\dts-ver-3.3-main (1)\dts-ver-3.3-main\resources\views/dts/create-new-document.blade.php ENDPATH**/ ?>