<?php $__env->startSection('content'); ?>

<div class="d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
    <h6 class="fw-semibold text-success mb-0 d-none d-md-block">
        <?php echo e($systemSetting->custom_system_name); ?>

    </h6>
    <ul class="d-flex align-items-center gap-2">
      <li class="fw-medium">
        <a href="<?php echo e(route('dashboard')); ?>" class="d-flex align-items-center gap-1 hover-text-primary">
          <iconify-icon icon="solar:home-smile-angle-outline" class="icon text-lg"></iconify-icon>
         My Station Dashboard
        </a>
      </li>
      <li>-</li>
      <li class="fw-medium">
          
        <div class="btn-group dropstart">
            <button class="btn btn-success-600 bg-success-100 border-success-100 text-success-600 hover-text-success not-active px-18 py-11 dropdown-toggle toggle-icon icon-left" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                 <?php if(isset($mySection) && $mySection != NULL): ?>
                <?php echo e($mySection); ?>

                <?php elseif(isset($myAllSections) && count($myAllSections) > 0): ?>                        
                    Select Section
                <?php endif; ?>
            </button>
            <ul class="dropdown-menu">
                <?php if(isset($myAllSections)): ?>
                <?php $__currentLoopData = $myAllSections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $section): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li>
                        <a class="dropdown-item px-16 py-8 rounded text-secondary-light bg-hover-neutral-200 text-hover-neutral-900"
                           href="javascript:void(0)"
                           onclick="submitSectionForm('<?php echo e($section->id); ?>')">
                           <?php echo e($section->name); ?>

                        </a>
                    </li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                
            </ul>
        </div>
        
        <!-- Form to submit the selected section_id -->
        <form id="section-form" method="POST" action="<?php echo e(route('user.updateStation')); ?>" style="display: none;">
            <?php echo csrf_field(); ?>
            <input type="hidden" name="station_id" id="station-id">
        </form>
        <?php endif; ?>
    </li>
    </ul>
  </div>

  
      
      <div class="card basic-data-table">
        
        <div class="card-body">

          <?php if($errors->any()): ?>
              <div class="m-3 alert alert-danger bg-danger-100 text-danger-600 border-danger-100 px-24 py-11 mb-0 fw-semibold text-lg radius-8 d-flex align-items-center justify-content-between" role="alert">
              <div class="d-flex align-items-center gap-2">
              <iconify-icon icon="mdi:alert-circle-outline" class="icon text-xl"></iconify-icon>
              <ul>
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </ul>
              </div>
              <button class="remove-button text-danger-600 text-xxl line-height-1"> <iconify-icon icon="iconamoon:sign-times-light" class="icon"></iconify-icon></button>
              </div>
            <?php endif; ?>

         
               
    
  
  <div class="row">
    <div class="col-sm-6">
      <div class="card">
        <div class="card-header">
          <div class="fw-semibold text-primary mb-0">QR Scan <span id="qrcapture" class="text-success"></span></div>
        </div>
        <div class="card-body">          
          
          <form action="<?php echo e(route('dts.qrcode-search')); ?>" method="post" id="webcam-form" class="row g-2 justify-content-end">
            <?php echo csrf_field(); ?>
           <div id="scanner">
             <div id="reader" width="600px"></div>
             <input type="hidden" id="webcamqr_scan" name="doc_track">
           </div>
          
         
           </form>    
          
          
        </div>
      </div>
     
    </div>
    <div class="col-sm-6">
      <div class="card">    
        <div class="card-header">
          <div class="fw-semibold text-primary mb-0">Capture Result and Daily Counts</div>
          </div>    
        <div class="card-body">
          <h6 id="capture_qrcode" class="text-success"></h6>

           <div> <?php echo e($mySection); ?> Today's Received Counts</div>
          <h1 class="fw-semibold text-danger mb-0 text-center"> <?php echo e($sectionReceivedCount->today_count ?? ''); ?> </h1>
        </div>
        
        <?php if(session('success')): ?>
        <div class="alert alert-success bg-success-100 text-success-600 border-success-100 px-24 py-11 mb-0 fw-semibold text-lg radius-8 d-flex align-items-center justify-content-between" role="alert">
          <div class="d-flex align-items-center gap-2">
              <iconify-icon icon="akar-icons:double-check" class="icon text-xl"></iconify-icon>
              <?php echo e(session('success')); ?>

          </div>
          <button class="remove-button text-success-600 text-xxl line-height-1"> <iconify-icon icon="iconamoon:sign-times-light" class="icon"></iconify-icon></button>
      </div>
    <?php endif; ?>



      </div>

    </div>
  </div>




  
        </div>
      </div>





<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>

<script src="https://unpkg.com/html5-qrcode" type="text/javascript"></script>
<script type="text/javascript">
  function onScanSuccess(decodedText, decodedResult) {
    document.getElementById('webcamqr_scan').value = decodedText;
    document.getElementById('capture_qrcode').innerText = `Captured QR Code: ${decodedText}`;
    document.getElementById('qrcapture').innerText = `Result: ${decodedText}`;
    // setTimeout(() => {
      document.getElementById('webcam-form').submit();
    // }, 20);
  }

  function onScanFailure(error) {
    console.warn(`QR error = ${error}`);
  }

  let html5QrcodeScanner = new Html5QrcodeScanner(
    "reader", { fps: 5, qrbox: 250 });
  html5QrcodeScanner.render(onScanSuccess, onScanFailure);
</script>
  
  <?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.dts-admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\marny\Downloads\dts-ver-3.3-main (1)\dts-ver-3.3-main\resources\views/dts/dts-webcamscan.blade.php ENDPATH**/ ?>