<?php $__env->startSection('content'); ?>

<div class="d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
    <h6 class="fw-semibold text-success mb-0">
      <?php echo e($systemSetting->organization->name); ?>

      <?php echo e($systemSetting->custom_system_name); ?>

    </h6>
    <ul class="d-flex align-items-center gap-2">
      <li class="fw-medium">
        <a href="<?php echo e(route('dashboard')); ?>" class="d-flex align-items-center gap-1 hover-text-primary">
          <iconify-icon icon="solar:home-smile-angle-outline" class="icon text-lg"></iconify-icon>
         My Station Dashboard
        </a>
      </li>
      <li>-</li>
      <li class="fw-medium">
          
        <div class="btn-group dropstart">
            <button class="btn btn-success-600 bg-success-100 border-success-100 text-success-600 hover-text-success not-active px-18 py-11 dropdown-toggle toggle-icon icon-left" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                 <?php if(isset($mySection) && $mySection != NULL): ?>
                <?php echo e($mySection); ?>

                <?php elseif(isset($myAllSections) && count($myAllSections) > 0): ?>                        
                    Select Section
                <?php endif; ?>
            </button>
            <ul class="dropdown-menu">
                <?php if(isset($myAllSections)): ?>
                <?php $__currentLoopData = $myAllSections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $section): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li>
                        <a class="dropdown-item px-16 py-8 rounded text-secondary-light bg-hover-neutral-200 text-hover-neutral-900"
                           href="javascript:void(0)"
                           onclick="submitSectionForm('<?php echo e($section->id); ?>')">
                           <?php echo e($section->name); ?>

                        </a>
                    </li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                
            </ul>
        </div>
        
        <!-- Form to submit the selected section_id -->
        <form id="section-form" method="POST" action="<?php echo e(route('user.updateStation')); ?>" style="display: none;">
            <?php echo csrf_field(); ?>
            <input type="hidden" name="station_id" id="station-id">
        </form>
        <?php endif; ?>
    </li>
    </ul>
  </div>

  
      
      <div class="card basic-data-table">
        
        <div class="card-body">

          <?php if($errors->any()): ?>
              <div class="m-3 alert alert-danger bg-danger-100 text-danger-600 border-danger-100 px-24 py-11 mb-0 fw-semibold text-lg radius-8 d-flex align-items-center justify-content-between" role="alert">
              <div class="d-flex align-items-center gap-2">
              <iconify-icon icon="mdi:alert-circle-outline" class="icon text-xl"></iconify-icon>
              <ul>
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </ul>
              </div>
              <button class="remove-button text-danger-600 text-xxl line-height-1"> <iconify-icon icon="iconamoon:sign-times-light" class="icon"></iconify-icon></button>
              </div>
            <?php endif; ?>

         <div class="row">
          <div class="col-sm-12">  
            <?php if(isset($document) && $document != NULL): ?>      
         <div class="card">
          <div class="card-heading"><h5> Search Result</h5></div>
          <div class="card-body">
       
            <table class="table table-bordered">
              <thead>
                <tr>
                  <th>Tracking Code</th>
                  <th>Description</th>
                  <th> Routed to </th>
                  <th style="width: 10%;">Action</th>
                </tr>
              </thead>
              <tbody>
              <tr>
                <td><?php echo e($document->tracking_code); ?></td>
                <td>
                  DocType: <?php echo e($document->doc_type_description); ?> <br>
                  <?php echo e($document->description); ?>

                </td>
                <td><?php echo e($document->for_section_name ?? ''); ?></td>
                <td>
                  <?php if($document->routeForSecId==Auth::user()->section_id && $document->routeDateAccepted!=NULL): ?>
                    Received on:  <?php echo date('m/d/Y @ h:i:s A', strtotime($document->routeDateAccepted)); ?>
                  <?php else: ?>
                  <form action="<?php echo e(route('dts.quick-receipt')); ?>" method="POST" style="display:inline;">
                    <?php echo csrf_field(); ?>
                    <input type="hidden"  name="doc_track" value="<?php echo e($document->tracking_code); ?>" >
                    <button type="submit" class="btn btn-primary btn-sm">Accept</button>
                </form>

                <?php endif; ?>
                </td>
              </tr>
            </tbody>
            </table>
            

          </div>          
        </div>   <!-- //card --> 
        <?php endif; ?>
          </div>
        
         </div> <!--//row-->
  
 <div>
 
 </div>




  
        </div>
      </div>





<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>


  
<script>
  document.getElementById('doc_track').addEventListener('change', function() {
      document.getElementById('qrcode-form').submit();
  });
</script>
  <?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.dts-admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\marny\Downloads\dts-ver-3.3-main (1)\dts-ver-3.3-main\resources\views/dts/dts-qrsearch-result.blade.php ENDPATH**/ ?>