<!DOCTYPE html>
<html lang="en" data-theme="light">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title><?php echo e(config('app.name', 'DepEd DTS')); ?></title>
  
  
  <link rel="icon" type="image/png" href="<?php echo e(asset('assets/images/favicon.png')); ?>" sizes="16x16">
  <!-- remix icon font css  -->
  <link rel="stylesheet" href="<?php echo e(asset('assets/css/remixicon.css')); ?>">
  <!-- BootStrap css -->
  <link rel="stylesheet" href="<?php echo e(asset('assets/css/lib/bootstrap.min.css')); ?>">
  <!-- Apex Chart css -->
  <link rel="stylesheet" href="<?php echo e(asset('assets/css/lib/apexcharts.css')); ?>">
  <!-- Data Table css -->
  <link rel="stylesheet" href="<?php echo e(asset('assets/css/lib/dataTables.min.css')); ?>">
  <!-- Text Editor css -->
  <link rel="stylesheet" href="<?php echo e(asset('assets/css/lib/editor-katex.min.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(asset('assets/css/lib/editor.atom-one-dark.min.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(asset('assets/css/lib/editor.quill.snow.css')); ?>">
  <!-- Date picker css -->
  <link rel="stylesheet" href="<?php echo e(asset('assets/css/lib/flatpickr.min.css')); ?>">
  <!-- Calendar css -->
  <link rel="stylesheet" href="<?php echo e(asset('assets/css/lib/full-calendar.css')); ?>">
  <!-- Vector Map css -->
  <link rel="stylesheet" href="<?php echo e(asset('assets/css/lib/jquery-jvectormap-2.0.5.css')); ?>">
  <!-- Popup css -->
  <link rel="stylesheet" href="<?php echo e(asset('assets/css/lib/magnific-popup.css')); ?>">
  <!-- Slick Slider css -->
  <link rel="stylesheet" href="<?php echo e(asset('assets/css/lib/slick.css')); ?>">
  <!-- main css -->
  <link rel="stylesheet" href="<?php echo e(asset('assets/css/style.css')); ?>">
</head>
<body>
<?php if(Auth::check()): ?>
    <script>
     window.location.href = "<?php echo e(url('/dashboard')); ?>";
    </script>
 <?php endif; ?>

<section class="auth bg-base d-flex flex-wrap">  
    <div class="auth-left d-lg-block d-none">
        <div class="d-flex align-items-center flex-column h-100 justify-content-center">
            <img src="<?php echo e(asset('assets/images/dts-system-welcome.png')); ?>" alt="Auth Image">
        </div>
    </div>
    <div class="auth-right py-32 px-24 d-flex flex-column justify-content-center">
        <div class="max-w-464-px mx-auto w-100">
            <div>
                <a href="<?php echo e(url('/')); ?>" class="mb-40 max-w-290-px">
                    <img src="<?php echo e(asset('assets/images/logo-dts.png')); ?>" alt="Logo">
                </a>
                <h4 class="mb-12">Sign In to your Account</h4>
                <p class="mb-32 text-secondary-light text-lg">Welcome back! Please enter your details</p>
            </div>
            <!-- Session Status -->
            <?php if (isset($component)) { $__componentOriginal7c1bf3a9346f208f66ee83b06b607fb5 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal7c1bf3a9346f208f66ee83b06b607fb5 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.auth-session-status','data' => ['class' => 'mb-4','status' => session('status')]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('auth-session-status'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'mb-4','status' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(session('status'))]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal7c1bf3a9346f208f66ee83b06b607fb5)): ?>
<?php $attributes = $__attributesOriginal7c1bf3a9346f208f66ee83b06b607fb5; ?>
<?php unset($__attributesOriginal7c1bf3a9346f208f66ee83b06b607fb5); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal7c1bf3a9346f208f66ee83b06b607fb5)): ?>
<?php $component = $__componentOriginal7c1bf3a9346f208f66ee83b06b607fb5; ?>
<?php unset($__componentOriginal7c1bf3a9346f208f66ee83b06b607fb5); ?>
<?php endif; ?>

            <form method="POST" action="<?php echo e(route('login')); ?>">
                <?php echo csrf_field(); ?>

                <!-- Email Address -->
                <div class="icon-field mb-16">
                    <span class="icon top-50 translate-middle-y">
                        <iconify-icon icon="mage:email"></iconify-icon>
                    </span>
                    <input id="email" type="email" class="form-control h-56-px bg-neutral-50 radius-12" name="email" :value="old('email')" required autofocus placeholder="Email">
                    <?php if (isset($component)) { $__componentOriginalf94ed9c5393ef72725d159fe01139746 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf94ed9c5393ef72725d159fe01139746 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.input-error','data' => ['messages' => $errors->get('email'),'class' => 'mt-2']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('input-error'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['messages' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($errors->get('email')),'class' => 'mt-2']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf94ed9c5393ef72725d159fe01139746)): ?>
<?php $attributes = $__attributesOriginalf94ed9c5393ef72725d159fe01139746; ?>
<?php unset($__attributesOriginalf94ed9c5393ef72725d159fe01139746); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf94ed9c5393ef72725d159fe01139746)): ?>
<?php $component = $__componentOriginalf94ed9c5393ef72725d159fe01139746; ?>
<?php unset($__componentOriginalf94ed9c5393ef72725d159fe01139746); ?>
<?php endif; ?>
                </div>

                <!-- Password -->
                <div class="position-relative mb-20">
                    <div class="icon-field">
                        <span class="icon top-50 translate-middle-y">
                            <iconify-icon icon="solar:lock-password-outline"></iconify-icon>
                        </span> 
                        <input id="password" type="password" class="form-control h-56-px bg-neutral-50 radius-12" name="password" required autocomplete="current-password" placeholder="Password">
                    </div>
                    <span class="toggle-password ri-eye-line cursor-pointer position-absolute end-0 top-50 translate-middle-y me-16 text-secondary-light" data-toggle="#password"></span>
                    <?php if (isset($component)) { $__componentOriginalf94ed9c5393ef72725d159fe01139746 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf94ed9c5393ef72725d159fe01139746 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.input-error','data' => ['messages' => $errors->get('password'),'class' => 'mt-2']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('input-error'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['messages' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($errors->get('password')),'class' => 'mt-2']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf94ed9c5393ef72725d159fe01139746)): ?>
<?php $attributes = $__attributesOriginalf94ed9c5393ef72725d159fe01139746; ?>
<?php unset($__attributesOriginalf94ed9c5393ef72725d159fe01139746); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf94ed9c5393ef72725d159fe01139746)): ?>
<?php $component = $__componentOriginalf94ed9c5393ef72725d159fe01139746; ?>
<?php unset($__componentOriginalf94ed9c5393ef72725d159fe01139746); ?>
<?php endif; ?>
                </div>

                <!-- Remember Me -->
                

                <!-- Forgot Password -->
                

                <!-- Sign In Button -->
                <button type="submit" class="btn btn-primary text-sm btn-sm px-12 py-16 w-100 radius-12 mt-32"> 
                    <?php echo e(__('Sign In')); ?>

                </button>
            </form>

            <div class="mt-32 text-center text-sm">
                <p class="mb-0">Don’t have an account? Ask your system administrator. </p>
                <?php if($allowGuestDocForm): ?>
                <p>or Encode your Document Details here.   <a href="<?php echo e(route('guest-dts')); ?>" class="text-primary-600 fw-semibold">Guest-DTS</a></p>
                 <?php endif; ?>
            </div>
        </div>
    </div>
</section>

<!-- jQuery library js -->
<script src="<?php echo e(asset('assets/js/lib/jquery-3.7.1.min.js')); ?>"></script>
<!-- Bootstrap js -->
<script src="<?php echo e(asset('assets/js/lib/bootstrap.bundle.min.js')); ?>"></script>
<!-- Apex Chart js -->
<script src="<?php echo e(asset('assets/js/lib/apexcharts.min.js')); ?>"></script>
<!-- Data Table js -->
<script src="<?php echo e(asset('assets/js/lib/dataTables.min.js')); ?>"></script>
<!-- Iconify Font js -->
<script src="<?php echo e(asset('assets/js/lib/iconify-icon.min.js')); ?>"></script>
<!-- jQuery UI js -->
<script src="<?php echo e(asset('assets/js/lib/jquery-ui.min.js')); ?>"></script>
<!-- Vector Map js -->
<script src="<?php echo e(asset('assets/js/lib/jquery-jvectormap-2.0.5.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/lib/jquery-jvectormap-world-mill-en.js')); ?>"></script>
<!-- Popup js -->
<script src="<?php echo e(asset('assets/js/lib/magnifc-popup.min.js')); ?>"></script>
<!-- Slick Slider js -->
<script src="<?php echo e(asset('assets/js/lib/slick.min.js')); ?>"></script>
<!-- main js -->
<script src="<?php echo e(asset('assets/js/app.js')); ?>"></script>
<script>
  // Password Show/Hide Toggle
  function initializePasswordToggle(toggleSelector) {
    $(toggleSelector).on('click', function() {
      $(this).toggleClass("ri-eye-off-line");
      var input = $($(this).attr("data-toggle"));
      if (input.attr("type") === "password") {
        input.attr("type", "text");
      } else {
        input.attr("type", "password");
      }
    });
  }
  // Call the function
  initializePasswordToggle('.toggle-password');
</script>
</body>
</html>
<?php /**PATH C:\Users\marny\Downloads\dts-ver-3.3-main (1)\dts-ver-3.3-main\resources\views/sign-in.blade.php ENDPATH**/ ?>