<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Permission;

class PermissionsTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $permissions = [
            [
                'id'    => 1,
                'title' => 'user_management_access',
                'created_at' =>date('Y-m-d H:i:s'), 
            ],
            [
                'id'    => 2,
                'title' => 'permission_create',
                'created_at' =>date('Y-m-d H:i:s'),
            ],
            [
                'id'    => 3,
                'title' => 'permission_edit',
                'created_at' =>date('Y-m-d H:i:s'),
            ],
            [
                'id'    => 4,
                'title' => 'permission_show',
                'created_at' =>date('Y-m-d H:i:s'),
            ],
            [
                'id'    => 5,
                'title' => 'permission_delete',
                'created_at' =>date('Y-m-d H:i:s'),
            ],
            [
                'id'    => 6,
                'title' => 'permission_access',
                'created_at' =>date('Y-m-d H:i:s'),
            ],
            [
                'id'    => 7,
                'title' => 'role_create',
                'created_at' =>date('Y-m-d H:i:s'),
            ],
            [
                'id'    => 8,
                'title' => 'role_edit',
                'created_at' =>date('Y-m-d H:i:s'),
            ],
            [
                'id'    => 9,
                'title' => 'role_show',
                'created_at' =>date('Y-m-d H:i:s'),
            ],
            [
                'id'    => 10,
                'title' => 'role_delete',
                'created_at' =>date('Y-m-d H:i:s'),
            ],
            [
                'id'    => 11,
                'title' => 'role_access',
                'created_at' =>date('Y-m-d H:i:s'),
            ],
            [
                'id'    => 12,
                'title' => 'user_create',
                'created_at' =>date('Y-m-d H:i:s'),
            ],
            [
                'id'    => 13,
                'title' => 'user_edit',
                'created_at' =>date('Y-m-d H:i:s'),
            ],
            [
                'id'    => 14,
                'title' => 'user_show',
                'created_at' =>date('Y-m-d H:i:s'),
            ],
            [
                'id'    => 15,
                'title' => 'user_delete',
                'created_at' =>date('Y-m-d H:i:s'),
            ],
            [
                'id'    => 16,
                'title' => 'user_access',
                'created_at' =>date('Y-m-d H:i:s'),
            ]
            ];
            Permission::insert($permissions);

            $newPermissions=[
                [
                    'id'=> 17,
                    'title' => "dts_access",
                    'group' => 2,
                    'remarks' => "dts system permission",
                    'created_at' =>date('Y-m-d H:i:s'),
                  ],
                  [
                    'id'=> 18,
                    'title' => "dts_batch_release_access",
                    'group' => 2,
                    'remarks' => "dts system permission",
                    'created_at' =>date('Y-m-d H:i:s'),
                  ],
                  [
                    'id'=> 19,
                    'title' => "dts_batch_release_create",
                    'group' => 2,
                    'remarks' => "dts system permission",
                    'created_at' =>date('Y-m-d H:i:s'),
                  ],
                  [
                    'id'=> 20,
                    'title' => "dts_batch_release_delete",
                    'group' => 2,
                    'remarks' => "dts system permission",
                    'created_at' =>date('Y-m-d H:i:s'),
                  ],
                  [
                    'id'=> 21,
                    'title' => "dts_batch_release_edit",
                    'group' => 2,
                    'remarks' => "dts system permission",
                    'created_at' =>date('Y-m-d H:i:s'),
                  ],
                  [
                    'id'=> 22,
                    'title' => "dts_batch_release_finalize",
                    'group' => 2,
                    'remarks' => "dts system permission",
                    'created_at' =>date('Y-m-d H:i:s'),
                  ],
                  [
                    'id'=> 23,
                    'title' => "dts_doc_create_n_forward",
                    'group' => 2,
                    'remarks' => "dts system permission",
                    'created_at' =>date('Y-m-d H:i:s'),
                  ],
                  [
                    'id'=> 24,
                    'title' => "dts_doctype_access",
                    'group' => 2,
                    'remarks' => "dts system permission",
                    'created_at' =>date('Y-m-d H:i:s'),
                  ],
                  [
                    'id'=> 25,
                    'title' => "dts_doctype_create",
                    'group' => 2,
                    'remarks' => "dts system permission",
                    'created_at' =>date('Y-m-d H:i:s'),
                  ],
                  [
                    'id'=> 26,
                    'title' => "dts_doctype_delete",
                    'group' => 2,
                    'remarks' => "dts system permission",
                    'created_at' =>date('Y-m-d H:i:s'),
                  ],
                  [
                    'id'=> 27,
                    'title' => "dts_doctype_edit",
                    'group' => 2,
                    'remarks' => "dts system permission",
                    'created_at' =>date('Y-m-d H:i:s'),
                  ],
                  [
                    'id'=> 28,
                    'title' => "dts_document_attachfile",
                    'group' => 2,
                    'remarks' => "dts system permission",
                    'created_at' =>date('Y-m-d H:i:s'),
                  ],
                  [
                    'id'=> 29,
                    'title' => "dts_document_create",
                    'group' => 2,
                    'remarks' => "dts system permission",
                    'created_at' =>date('Y-m-d H:i:s'),
                  ],
                  [
                    'id'=> 30,
                    'title' => "dts_document_delete",
                    'group' => 2,
                    'remarks' => "dts system permission",
                    'created_at' =>date('Y-m-d H:i:s'),
                  ],
                  [
                    'id'=> 31,
                    'title' => "dts_document_edit",
                    'group' => 2,
                    'remarks' => "dts system permission",
                    'created_at' =>date('Y-m-d H:i:s'),
                  ],
                  [
                    'id'=> 32,
                    'title' => "dts_document_show",
                    'group' => 2,
                    'remarks' => "dts system permission",
                    'created_at' =>date('Y-m-d H:i:s'),
                  ],
                  [
                    'id'=> 33,
                    'title' => "dts_guest_doc_access",
                    'group' => 2,
                    'remarks' => "dts system permission",
                    'created_at' =>date('Y-m-d H:i:s'),
                  ],
                  [
                    'id'=> 34,
                    'title' => "dts_guest_doc_create",
                    'group' => 2,
                    'remarks' => "dts system permission",
                    'created_at' =>date('Y-m-d H:i:s'),
                  ],
                  [
                    'id'=> 35,
                    'title' => "dts_guest_doc_delete",
                    'group' => 2,
                    'remarks' => "dts system permission",
                    'created_at' =>date('Y-m-d H:i:s'),
                  ],
                  [
                    'id'=> 36,
                    'title' => "dts_guest_doc_edit",
                    'group' => 2,
                    'remarks' => "dts system permission",
                    'created_at' =>date('Y-m-d H:i:s'),
                  ],
                  [
                    'id'=> 37,
                    'title' => "dts_print_qrcode",
                    'group' => 2,
                    'remarks' => "dts system permission",
                    'created_at' =>date('Y-m-d H:i:s'),
                  ],
                  [
                    'id'=> 38,
                    'title' => "dts_records_mngt",
                    'group' => 2,
                    'remarks' => "dts system permission",
                    'created_at' =>date('Y-m-d H:i:s'),
                  ],
                  [
                    'id'=> 39,
                    'title' => "dts_records_mngt_create",
                    'group' => 2,
                    'remarks' => "dts system permission",
                    'created_at' =>date('Y-m-d H:i:s'),
                  ],
                  [
                    'id'=> 40,
                    'title' => "dts_records_mngt_edit",
                    'group' => 2,
                    'remarks' => "dts system permission",
                    'created_at' =>date('Y-m-d H:i:s'),
                  ],
                  [
                    'id'=> 41,
                    'title' => "dts_reports_access",
                    'group' => 2,
                    'remarks' => "dts system permission",
                    'created_at' =>date('Y-m-d H:i:s'),
                  ],
                  [
                    'id'=> 42,
                    'title' => "dts_reports_all_access",
                    'group' => 2,
                    'remarks' => "dts system permission",
                    'created_at' =>date('Y-m-d H:i:s'),
                  ],
                  [
                    'id'=> 43,
                    'title' => "dts_reports_personal_access",
                    'group' => 2,
                    'remarks' => "dts system permission",
                    'created_at' =>date('Y-m-d H:i:s'),
                  ],
                  [
                    'id'=> 44,
                    'title' => "dts_reports_section_access",
                    'group' => 2,
                    'remarks' => "dts system permission",
                    'created_at' =>date('Y-m-d H:i:s'),
                  ],
                  [
                    'id'=> 45,
                    'title' => "dts_route_access",
                    'group' => 2,
                    'remarks' => "dts system permission",
                    'created_at' =>date('Y-m-d H:i:s'),
                  ],
                  [
                    'id'=> 46,
                    'title' => "dts_route_batchrelease",
                    'group' => 2,
                    'remarks' => "dts system permission",
                    'created_at' =>date('Y-m-d H:i:s'),
                  ],
                  [
                    'id'=> 47,
                    'title' => "dts_route_create",
                    'group' => 2,
                    'remarks' => "dts system permission",
                    'created_at' =>date('Y-m-d H:i:s'),
                  ],
                  [
                    'id'=> 48,
                    'title' => "dts_route_defer",
                    'group' => 2,
                    'remarks' => "dts system permission",
                    'created_at' =>date('Y-m-d H:i:s'),
                  ],
                  [
                    'id'=> 49,
                    'title' => "dts_route_defer_access",
                    'group' => 2,
                    'remarks' => "dts system permission",
                    'created_at' =>date('Y-m-d H:i:s'),
                  ],
                  [
                    'id'=> 50,
                    'title' => "dts_route_delete",
                    'group' => 2,
                    'remarks' => "dts system permission",
                    'created_at' =>date('Y-m-d H:i:s'),
                  ],
                  [
                    'id'=> 51,
                    'title' => "dts_route_edit",
                    'group' => 2,
                    'remarks' => "dts system permission",
                    'created_at' =>date('Y-m-d H:i:s'),
                  ],
                  [
                    'id'=> 52,
                    'title' => "dts_route_kept_file",
                    'group' => 2,
                    'remarks' => "dts system permission",
                    'created_at' =>date('Y-m-d H:i:s'),
                  ],
                  [
                    'id'=> 53,
                    'title' => "dts_route_parked_incomming_access",
                    'group' => 2,
                    'remarks' => "dts system permission",
                    'created_at' =>date('Y-m-d H:i:s'),
                  ],
                  [
                    'id'=> 54,
                    'title' => "dts_route_parked_pending_access",
                    'group' => 2,
                    'remarks' => "dts system permission",
                    'created_at' =>date('Y-m-d H:i:s'),
                  ],
                  [
                    'id'=> 55,
                    'title' => "dts_route_pending_access",
                    'group' => 2,
                    'remarks' => "dts system permission",
                    'created_at' =>date('Y-m-d H:i:s'),
                  ],
                  [
                    'id'=> 56,
                    'title' => "dts_route_receive",
                    'group' => 2,
                    'remarks' => "dts accepting document",
                    'created_at' =>date('Y-m-d H:i:s'),
                  ],
                  [
                    'id'=> 57,
                    'title' => "dts_route_receive_nfile",
                    'group' => 2,
                    'remarks' => "dts accept and kept file",
                    'created_at' =>date('Y-m-d H:i:s'),
                  ],
                  [
                    'id'=> 58,
                    'title' => "dts_route_received_access",
                    'group' => 2,
                    'remarks' => "dts system permission",
                    'created_at' =>date('Y-m-d H:i:s'),
                  ],
                  [
                    'id'=> 59,
                    'title' => "dts_route_reenter_access",
                    'group' => 2,
                    'remarks' => "dts system permission",
                    'created_at' =>date('Y-m-d H:i:s'),
                  ],
                  [
                    'id'=> 60,
                    'title' => "dts_route_release",
                    'group' => 2,
                    'remarks' => "dts system permission",
                    'created_at' =>date('Y-m-d H:i:s'),
                  ],
                  [
                    'id'=> 61,
                    'title' => "dts_route_released_access",
                    'group' => 2,
                    'remarks' => "dts system permission",
                    'created_at' =>date('Y-m-d H:i:s'),
                  ],
                  [
                    'id'=> 62,
                    'title' => "dts_route_show",
                    'group' => 2,
                    'remarks' => "dts system permission",
                    'created_at' =>date('Y-m-d H:i:s'),
                  ],
                  [
                    'id'=> 63,
                    'title' => "dts_section_acces",
                    'group' => 2,
                    'remarks' => "dts system permission",
                    'created_at' =>date('Y-m-d H:i:s'),
                  ],
                  [
                    'id'=> 64,
                    'title' => "dts_section_create",
                    'group' => 2,
                    'remarks' => "dts system permission",
                    'created_at' =>date('Y-m-d H:i:s'),
                  ],
                  [
                    'id'=> 65,
                    'title' => "dts_section_delete",
                    'group' => 2,
                    'remarks' => "dts system permission",
                    'created_at' =>date('Y-m-d H:i:s'),
                  ],
                  [
                    'id'=> 66,
                    'title' => "dts_section_edit",
                    'group' => 2,
                    'remarks' => "dts system permission",
                    'created_at' =>date('Y-m-d H:i:s'),
                  ],
                  [
                    'id'=> 67,
                    'title' => "dts_settings_access",
                    'group' => 2,
                    'remarks' => "dts system permission",
                    'created_at' =>date('Y-m-d H:i:s'),
                  ],
                  [
                    'id'=> 68,
                    'title' => "dts_settings_edit",
                    'group' => 2,
                    'remarks' => "dts system permission",
                    'created_at' =>date('Y-m-d H:i:s'),
                  ],
                  [
                    'id'=> 69,
                    'title' => "dts_system_archiving",
                    'group' => 2,
                    'remarks' => "dts system permission",
                    'created_at' =>date('Y-m-d H:i:s'),
                  ],
                  [
                    'id'=> 70,
                    'title' => "dts_system_housekeeping",
                    'group' => 2,
                    'remarks' => "dts system permission",
                    'created_at' =>date('Y-m-d H:i:s'),
                  ],
                  [
                    'id'=> 71,
                    'title' => "dts_user_access",
                    'group' => 2,
                    'remarks' => "dts system permission",
                    'created_at' =>date('Y-m-d H:i:s'),
                  ],
                  [
                    'id'=> 72,
                    'title' => "dts_user_assign_section",
                    'group' => 2,
                    'remarks' => "dts system permission",
                    'created_at' =>date('Y-m-d H:i:s'),
                  ],
                  [
                    'id'=> 73,
                    'title' => "dts_user_create",
                    'group' => 2,
                    'remarks' => "dts system permission",
                    'created_at' =>date('Y-m-d H:i:s'),
                  ],
                  [
                    'id'=> 74,
                    'title' => "dts_user_edit",
                    'group' => 2,
                    'remarks' => "dts system permission",
                    'created_at' =>date('Y-m-d H:i:s'),
                  ],
                ];
                  Permission::insert($newPermissions);
            
    }
}
